﻿© Fluke Calibration. All Rights Reserved.                  MET/CAL Procedure
=============================================================================
INSTRUMENT:            System Information Functions
DATE:                  2011-12-13 17:11:50
AUTHOR:                Fluke
REVISION:              n/a
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       105
=============================================================================
#
# This procedure uses the following WIN32 functions:
#
# kernel32.dll
#   GetVersion()
#   GetWindowsDirectory()
#   GetSystemWindowsDirectory()
#   GetComputerName()
#   GetComputerNameEx()
#
# Advapi32.dll
#   GetUserName()
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  LIB          DLL kernel32 = "kernel32.dll";
  1.002  LIB          DLL Advapi32 = "Advapi32.dll";

# GetVersion()
  1.003  LIB          Version = kernel32.GetVersion();

# GetUserName()
  1.004  MATH         UserName = ""; Buffer = 100
  1.005  LIB          ret = Advapi32.GetUserName(UserName, Buffer);
  1.006  DISP         User name:
  1.006  DISP         [V UserName]

# GetWindowsDirectory()
  1.007  MATH         WinDir = ""; Buffer = 255
  1.008  LIB          ret = kernel32.GetWindowsDirectory(WinDir, Buffer);
  1.009  DISP         Windows Directory:
  1.009  DISP         [V WinDir]

# GetSystemWindowsDirectory()
  1.010  MATH         SysWinDir = ""; Buffer = 255
  1.011  LIB          ret = kernel32.GetSystemWindowsDirectory
  1.011  LIB          (SysWinDir, Buffer);
  1.012  DISP         System Windows Directory:
  1.012  DISP         [V SysWinDir]

# -----  GetComputerName() examples
  1.013  MATH         Computer = ""; Buffer = 255
  1.014  LIB          ret = kernel32.GetComputerName(Computer, Buffer);
  1.015  DISP         Computer name:
  1.015  DISP         [V Computer]

# arg1 = 0, NetBIOS
  1.016  MATH         Computer = ""; Buffer = 255
  1.017  LIB          ret = kernel32.GetComputerNameEx(0, Computer, Buffer);
  1.018  DISP         Computer name, NetBios:
  1.018  DISP         [V Computer]

# arg1 = 1, DNS hostname
  1.019  MATH         Computer = ""; Buffer = 255
  1.020  LIB          ret = kernel32.GetComputerNameEx(1, Computer, Buffer);
  1.021  DISP         Computer name, DNS Hostname:
  1.021  DISP         [V Computer]

# arg1 = 2, DNS domain
  1.022  MATH         Computer = ""; Buffer = 255
  1.023  LIB          ret = kernel32.GetComputerNameEx(2, Computer, Buffer);
  1.024  DISP         Computer name, DNS domain:
  1.024  DISP         [V Computer]

# arg1 = 3, DNS fully-qualified
  1.025  MATH         Computer = ""; Buffer = 255
  1.026  LIB          ret = kernel32.GetComputerNameEx(3, Computer, Buffer);
  1.027  DISP         Computer name, DNS fully-qualified:
  1.027  DISP         [V Computer]

# arg1 = 4, Physical NetBIOS
  1.028  MATH         Computer = ""; Buffer = 255
  1.029  LIB          ret = kernel32.GetComputerNameEx(4, Computer, Buffer);
  1.030  DISP         Computer name, Physical NetBIOS:
  1.030  DISP         [V Computer]

# arg1 = 5, Physical DNS Hostname
  1.031  MATH         Computer = ""; Buffer = 255
  1.032  LIB          ret = kernel32.GetComputerNameEx(5, Computer, Buffer);
  1.033  DISP         Computer name, Physical DNS Hostname:
  1.033  DISP         [V Computer]

# arg1 = 6, Physical DNS domain
  1.034  MATH         Computer = ""; Buffer = 255
  1.035  LIB          ret = kernel32.GetComputerNameEx(6, Computer, Buffer);
  1.036  DISP         Computer name, Physical DNS domain:
  1.036  DISP         [V Computer]

# arg1 = 7, Physical DNS fully-qualified
  1.037  MATH         Computer = ""; Buffer = 255
  1.038  LIB          ret = kernel32.GetComputerNameEx(7, Computer, Buffer);
  1.039  DISP         Computer name, Physical DNS fully-qualified:
  1.039  DISP         [V Computer]

  1.040  END